/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.redis.clients.jedis.mcf;

import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.impactdev.impactor.relocations.redis.clients.jedis.CommandArguments;
import net.impactdev.impactor.relocations.redis.clients.jedis.CommandObject;
import net.impactdev.impactor.relocations.redis.clients.jedis.CommandObjects;
import net.impactdev.impactor.relocations.redis.clients.jedis.Connection;
import net.impactdev.impactor.relocations.redis.clients.jedis.PipelineBase;
import net.impactdev.impactor.relocations.redis.clients.jedis.RedisProtocol;
import net.impactdev.impactor.relocations.redis.clients.jedis.Response;
import net.impactdev.impactor.relocations.redis.clients.jedis.graph.ResultSet;
import net.impactdev.impactor.relocations.redis.clients.jedis.mcf.CircuitBreakerFailoverConnectionProvider;
import net.impactdev.impactor.relocations.redis.clients.jedis.providers.MultiClusterPooledConnectionProvider;
import net.impactdev.impactor.relocations.redis.clients.jedis.util.KeyValue;

public class MultiClusterPipeline
extends PipelineBase
implements Closeable {
    private final CircuitBreakerFailoverConnectionProvider failoverProvider;
    private final Queue<KeyValue<CommandArguments, Response<?>>> commands = new LinkedList();

    @Deprecated
    public MultiClusterPipeline(MultiClusterPooledConnectionProvider pooledProvider) {
        super(new CommandObjects());
        this.failoverProvider = new CircuitBreakerFailoverConnectionProvider(pooledProvider);
        try (Connection connection = this.failoverProvider.getConnection();){
            RedisProtocol proto = connection.getRedisProtocol();
            if (proto != null) {
                this.commandObjects.setProtocol(proto);
            }
        }
    }

    public MultiClusterPipeline(MultiClusterPooledConnectionProvider pooledProvider, CommandObjects commandObjects) {
        super(commandObjects);
        this.failoverProvider = new CircuitBreakerFailoverConnectionProvider(pooledProvider);
    }

    @Override
    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        CommandArguments args2 = commandObject.getArguments();
        Response<T> response = new Response<T>(commandObject.getBuilder());
        this.commands.add(KeyValue.of(args2, response));
        return response;
    }

    @Override
    public void close() {
        this.sync();
    }

    @Override
    public void sync() {
        if (this.commands.isEmpty()) {
            return;
        }
        try (Connection connection = this.failoverProvider.getConnection();){
            this.commands.forEach(command -> connection.sendCommand((CommandArguments)command.getKey()));
            List<Object> unformatted = connection.getMany(this.commands.size());
            unformatted.forEach(rawReply -> ((Response)this.commands.poll().getValue()).set(rawReply));
        }
    }

    public Response<Long> waitReplicas(int replicas, long timeout2) {
        return this.appendCommand(this.commandObjects.waitReplicas(replicas, timeout2));
    }

    public Response<KeyValue<Long, Long>> waitAOF(long numLocal, long numReplicas, long timeout2) {
        return this.appendCommand(this.commandObjects.waitAOF(numLocal, numReplicas, timeout2));
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, long timeout2) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, long timeout2) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params, long timeout2) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params, long timeout2) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<String> graphDelete(String name) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<List<String>> graphProfile(String graphName, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }
}

